/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class InetVpnConfigData
implements Persistable {
    private static final String TRACE_MASKT = "XRCSIVDT";
    private static final String TRACE_MASKF = "XRCSIVDF";
    private static final String TRACE_MASKD = "XRCSIVDD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-IVpnData");
    private static final String PERSISTENCE_NAME = "com.ibm.hwmca.fw.rcs.outconn.InetVpnConfigData";
    private static InetVpnConfigData inetVpnConfigData = null;
    private boolean allowVpn = false;

    private InetVpnConfigData() {
        Trace.trace(TRACE_MASKT, "<> InetVpnConfigData()");
    }

    protected InetVpnConfigData(PersistentData data) throws PersistenceException {
        Persistent persistent = (Persistent)data;
        int version = persistent.version;
        this.allowVpn = persistent.allowVpn;
    }

    public PersistentData getPersistentData() {
        Persistent persistent = new Persistent();
        persistent.version = 1;
        persistent.allowVpn = this.allowVpn;
        return persistent;
    }

    public boolean isUpgradeData() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persist() {
        Trace.trace(TRACE_MASKT, "-> persist()");
        InetVpnConfigData inetVpnConfigData = this;
        synchronized (inetVpnConfigData) {
            try {
                PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, this);
            }
            catch (PersistenceException pe) {
                Trace.trace(TRACE_MASKF, "Unable to persist: " + pe.getMessage());
            }
        }
        Trace.trace(TRACE_MASKT, "<- persist()");
    }

    public static synchronized InetVpnConfigData getInetVpnConfigData() {
        Trace.trace(TRACE_MASKT, "-> getInetVpnConfigData()");
        if (inetVpnConfigData == null) {
            PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
            if (persMgr.contains(PERSISTENCE_NAME)) {
                try {
                    inetVpnConfigData = (InetVpnConfigData)persMgr.read(PERSISTENCE_NAME);
                }
                catch (PersistenceException pe) {
                    String desc = "Exception restoring persistent data:\n" + InetVpnConfigData.getStackTrace(pe);
                    Trace.trace(TRACE_MASKF, desc);
                    inetVpnConfigData = new InetVpnConfigData();
                }
            } else {
                String desc = "Persistent data com.ibm.hwmca.fw.rcs.outconn.InetVpnConfigData unavailable";
                Trace.trace(TRACE_MASKF, desc);
                inetVpnConfigData = new InetVpnConfigData();
            }
        }
        Trace.trace(TRACE_MASKT, "<- getInetVpnConfigData()");
        return inetVpnConfigData;
    }

    public boolean isAllowVpn() {
        return this.allowVpn;
    }

    void setAllowVpn(boolean value) {
        this.allowVpn = value;
    }

    private static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        throwable.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = 2913114916744137419L;
        int version;
        boolean allowVpn;

        private Persistent() {
        }
    }
}

